/*
 * Decompiled with CFR 0.152.
 */
package com.texelsaurus.minecraft.chameleon.config;

import com.texelsaurus.minecraft.chameleon.config.ConfigSpec;
import com.texelsaurus.minecraft.chameleon.service.ChameleonConfig;
import fuzs.forgeconfigapiport.api.config.v2.ForgeConfigRegistry;
import java.util.List;
import java.util.function.Predicate;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class ForgeApiConfig
implements ChameleonConfig {
    private final ConfigSpec localSpec;
    private final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public ForgeConfigSpec neoSpec;

    public ForgeApiConfig() {
        this.localSpec = null;
    }

    public ForgeApiConfig(ConfigSpec spec) {
        this.localSpec = spec;
    }

    @Override
    public void init(String modId, ChameleonConfig.Type type) {
        if (this.localSpec != null) {
            this.localSpec.init();
        }
        this.neoSpec = this.BUILDER.build();
        if (type == ChameleonConfig.Type.COMMON) {
            ForgeConfigRegistry.INSTANCE.register(modId, ModConfig.Type.COMMON, (IConfigSpec)this.neoSpec);
        } else if (type == ChameleonConfig.Type.CLIENT) {
            ForgeConfigRegistry.INSTANCE.register(modId, ModConfig.Type.CLIENT, (IConfigSpec)this.neoSpec);
        }
        if (this.localSpec != null) {
            this.localSpec.setLoaded();
        }
    }

    @Override
    public <T extends ChameleonConfig> T create(ConfigSpec spec) {
        return (T)new ForgeApiConfig(spec);
    }

    @Override
    public <T> ChameleonConfig.ConfigEntry<T> define(String name, T defaultValue) {
        return new ForgeConfigEntry(this.BUILDER).name(name).defaultValue(defaultValue);
    }

    @Override
    public <T extends Comparable<? super T>> ChameleonConfig.ConfigEntry<T> defineInRange(String name, T defaultValue, T min, T max, Class<T> clazz) {
        return new ForgeConfigEntryRange<T>(this.BUILDER, clazz).name(name).defaultValue(defaultValue).range(min, max);
    }

    @Override
    public <T extends Enum<T>> ChameleonConfig.ConfigEntry<T> defineEnum(String name, T defaultValue) {
        return new ForgeConfigEntryEnum(this.BUILDER).name(name).defaultValue(defaultValue);
    }

    @Override
    public <T> ChameleonConfig.ConfigEntry<List<? extends T>> defineList(String name, List<? extends T> defaultList, Predicate<Object> elementValidator) {
        return new ForgeConfigEntryList(this.BUILDER).validator(elementValidator).name(name).defaultValue(defaultList);
    }

    @Override
    public void pushGroup(String name) {
        this.BUILDER.push(name);
    }

    @Override
    public void popGroup() {
        this.BUILDER.pop();
    }

    public class ForgeConfigEntry<T>
    extends ChameleonConfig.ConfigEntry<T> {
        ForgeConfigSpec.Builder builder;
        ForgeConfigSpec.ConfigValue<T> value;

        public ForgeConfigEntry(ForgeConfigSpec.Builder builder) {
            this.builder = builder;
        }

        @Override
        public ChameleonConfig.ConfigEntry<T> build() {
            if (this.comment != null) {
                this.builder.comment(this.comment);
            }
            this.value = this.define();
            return this;
        }

        @Override
        public T get() {
            if (this.value == null) {
                return (T)this.defaultValue;
            }
            return (T)this.value.get();
        }

        @Override
        public void set(T t) {
            if (this.value != null) {
                this.value.set(t);
            }
        }

        protected ForgeConfigSpec.ConfigValue<T> define() {
            return this.builder.define(this.name, this.defaultValue);
        }
    }

    public class ForgeConfigEntryRange<T extends Comparable<? super T>>
    extends ForgeConfigEntry<T> {
        Class<T> clazz;

        public ForgeConfigEntryRange(ForgeConfigSpec.Builder builder, Class<T> clazz) {
            super(builder);
            this.clazz = clazz;
        }

        @Override
        protected ForgeConfigSpec.ConfigValue<T> define() {
            return this.builder.defineInRange(this.name, (Comparable)this.defaultValue, (Comparable)this.rangeMin, (Comparable)this.rangeMax, this.clazz);
        }
    }

    public class ForgeConfigEntryEnum<T extends Enum<T>>
    extends ForgeConfigEntry<T> {
        public ForgeConfigEntryEnum(ForgeConfigSpec.Builder builder) {
            super(builder);
        }

        @Override
        protected ForgeConfigSpec.ConfigValue<T> define() {
            return this.builder.defineEnum(this.name, (Enum)this.defaultValue);
        }
    }

    public class ForgeConfigEntryList<T>
    extends ForgeConfigEntry<List<? extends T>> {
        Predicate<Object> validator;

        public ForgeConfigEntryList(ForgeConfigSpec.Builder builder) {
            super(builder);
            this.validator = x -> true;
        }

        public ForgeConfigEntryList<T> validator(Predicate<Object> validtor) {
            if (validtor != null) {
                this.validator = validtor;
            }
            return this;
        }

        @Override
        protected ForgeConfigSpec.ConfigValue<List<? extends T>> define() {
            return this.builder.defineList(this.name, (List)this.defaultValue, this.validator);
        }
    }
}

